% The equations based on rate of every reaction :
dQ_H/dt = 2*r(1) - r(3) - r(4) - r(5)
dQ_N/dt = 2*r(2) - r(3)
dQ_NH/dt = r(3) - r(4)
dQ_NH2/dt = r(4) - r(5)
dQ_v/dt = r(3) - 2*r(2) - 2*r(1) + r(4) + 2*r(5)
dP_H2/dt = -Pn*(r(1) + (Fgt*P0*(P_H2 - Po_H2))/(NA*T*kB))
dP_N2/dt = -Pn*(r(2) + (Fgt*P0*(P_N2 - Po_N2))/(NA*T*kB))
dP_NH3/dt = Pn*(r(5) - (Fgt*P0*(P_NH3 - Po_NH3))/(NA*T*kB))
% The rate equations of every reaction :
r(1) = P_H2*Q_v^2*kf(1) - Q_H^2*kr(1)
r(2) = P_N2*Q_v^2*kf(2) - Q_N^2*kr(2)
r(3) = Q_H*Q_N*kf(3) - Q_NH*Q_v*kr(3)
r(4) = Q_H*Q_NH*kf(4) - Q_NH2*Q_v*kr(4)
r(5) = Q_H*Q_NH2*kf(5) - P_NH3*Q_v^2*kr(5)
% The equations based on P C Q kr kf :
dQ_H/dt = Q_NH*Q_v*kr(3) - Q_H*Q_N*kf(3) - Q_H*Q_NH*kf(4) - Q_H*Q_NH2*kf(5) - 2*Q_H^2*kr(1) + Q_NH2*Q_v*kr(4) + 2*P_H2*Q_v^2*kf(1) + P_NH3*Q_v^2*kr(5)
dQ_N/dt = Q_NH*Q_v*kr(3) - Q_H*Q_N*kf(3) - 2*Q_N^2*kr(2) + 2*P_N2*Q_v^2*kf(2)
dQ_NH/dt = Q_H*Q_N*kf(3) - Q_H*Q_NH*kf(4) - Q_NH*Q_v*kr(3) + Q_NH2*Q_v*kr(4)
dQ_NH2/dt = Q_H*Q_NH*kf(4) - Q_H*Q_NH2*kf(5) - Q_NH2*Q_v*kr(4) + P_NH3*Q_v^2*kr(5)
dQ_v/dt = 2*Q_H^2*kr(1) + 2*Q_N^2*kr(2) + Q_H*Q_N*kf(3) + Q_H*Q_NH*kf(4) + 2*Q_H*Q_NH2*kf(5) - Q_NH*Q_v*kr(3) - Q_NH2*Q_v*kr(4) - 2*P_H2*Q_v^2*kf(1) - 2*P_N2*Q_v^2*kf(2) - 2*P_NH3*Q_v^2*kr(5)
dP_H2/dt = -Pn*(P_H2*Q_v^2*kf(1) - Q_H^2*kr(1) + (Fgt*P0*(P_H2 - Po_H2))/(NA*T*kB))
dP_N2/dt = -Pn*(P_N2*Q_v^2*kf(2) - Q_N^2*kr(2) + (Fgt*P0*(P_N2 - Po_N2))/(NA*T*kB))
dP_NH3/dt = -Pn*(P_NH3*Q_v^2*kr(5) - Q_H*Q_NH2*kf(5) + (Fgt*P0*(P_NH3 - Po_NH3))/(NA*T*kB))
